package gov.va.med.mhv.usermgmt.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.usermgmt.common.dto.EmailDTO;

@Path("/")
@Service("emailService")
public interface EmailService {

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/sendEmail")
	boolean send(EmailDTO emailDto) throws EmailFailureException;
	
	boolean send(String from, String fromName, String subject, String message, String recipient, String messageContentType) throws EmailFailureException;

	boolean send(String from, String fromName, String subject, String message, List<String> recipients, String messageContentType) throws EmailFailureException;;

	boolean send(String from, String fromName, String subject, String message, List<String> recipients, String cc, String bcc, String messageContentType) throws EmailFailureException;;

	boolean send(String from, String fromName, String subject, String message, String recipient, String cc, String bcc, String messageContentType) throws EmailFailureException;;
}
